/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class RegionUtils {
    private static final List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> VANILLA_POINTS;
    private static Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> biomeParameterPointCache;

    public static List<Climate.ParameterPoint> getVanillaParameterPoints(ResourceKey<Biome> biome) {
        if (biomeParameterPointCache.containsKey(biome)) {
            return biomeParameterPointCache.get(biome);
        }
        List points = (List)VANILLA_POINTS.stream().filter(pair -> pair.getSecond() == biome).map(pair -> (Climate.ParameterPoint)pair.getFirst()).collect(ImmutableList.toImmutableList());
        biomeParameterPointCache.put(biome, points);
        return points;
    }

    static {
        biomeParameterPointCache = Maps.newHashMap();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        new OverworldBiomeBuilder().m_187175_(pair -> builder.add(pair));
        VANILLA_POINTS = builder.build();
    }
}

